//
//  WXKBookmarkWindow_DragAndDrop.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/08/27.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
//
//  Some part of this source code is derived from DNDArrayController.h, 
//  written by raktajino in AH-K3001V Bookmark Utility and distributed
//  under BSD license.
//  See the following about copyrights.
//
//
//  Created by raktajino on Thu Jun 17 2004.
//  Copyright (c) 2004 raktajino. All rights reserved.
//
//		Copyright (c) 04 Zoroyoshi, Japan
//		All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "WXKBookmarkWindowController.h"
#import "FJDIndexedItemsArrayController.h"


@implementation WXKBookmarkWindowController (DragAndDrop)

- (NSArray *)readablePasteboardTypes
{
	return [[super readablePasteboardTypes] arrayByAddingObject:NSURLPboardType];
}

- (BOOL)tableView:(NSTableView *)tableView writeRowsWithIndexes:(NSIndexSet *)rowIndexes toPasteboard:(NSPasteboard *)pboard
{
	BOOL flag = [super tableView:tableView
			writeRowsWithIndexes:rowIndexes
					toPasteboard:pboard];
	
	if (tableView == itemsTableView && [rowIndexes count] == 1) {
		NSManagedObject *object = [[[itemsController arrangedObjects] objectsAtIndexes:rowIndexes] lastObject];
		NSString *URLString = [object valueForKey:@"url"];
		if (URLString && [URLString length] > 0) {
			NSURL *URL = [NSURL URLWithString:URLString];
			if (URL) {
				[pboard addTypes:[NSArray arrayWithObject:NSURLPboardType] owner:nil];
				[URL writeToPasteboard:pboard];
				return YES;
			}
		}
	}
	return flag;
}

- (NSDragOperation)tableView:(NSTableView *)tableView validateDrop:(id <NSDraggingInfo>)info proposedRow:(int)row proposedDropOperation:(NSTableViewDropOperation)operation
{
	NSDragOperation flag = [super tableView:tableView
							   validateDrop:info
								proposedRow:row
					  proposedDropOperation:operation];
	
	if (flag != NSDragOperationNone) {
		return flag;
	} 
	if (tableView == itemsTableView
		&& operation == NSTableViewDropAbove 
		&& [info draggingSource] == nil // drop from other application
		&& [[[info draggingPasteboard] types] containsObject:NSURLPboardType]) {
		return NSDragOperationCopy;
	}
	
	return NSDragOperationNone;
}

- (BOOL)tableView:(NSTableView*)tableView acceptDrop:(id <NSDraggingInfo>)info row:(int)row dropOperation:(NSTableViewDropOperation)operation
{
	if ([WXKWindowController instancesRespondToSelector:@selector(tableView:acceptDrop:row:dropOperation:)] 
		&&  [super tableView:tableView
				  acceptDrop:info
						 row:row
			   dropOperation:operation]) {
		
		return YES;
	
	}
	
	if (tableView == itemsTableView
		&& operation == NSTableViewDropAbove 
		&& [info draggingSource] == nil // drop from other application
		&& [[[info draggingPasteboard] types] containsObject:NSURLPboardType]) {
		
		NSPasteboard *pboard = [info draggingPasteboard];
		if ([[pboard types] containsObject:NSURLPboardType]) {
			NSURL *URL = [NSURL URLFromPasteboard:pboard];
			if (URL) {
				if ([itemsController canInsert] && [[foldersController selectedObjects] count] == 1) {
//					id object = [[itemsController newObject] autorelease];
					id object = [NSEntityDescription insertNewObjectForEntityForName:@"Bookmark"
					 inManagedObjectContext:[self managedObjectContext]];
					id folder = [[foldersController selectedObjects] lastObject];
					
					[object setValue:folder forKey:@"folder"];
					[object setValue:[URL absoluteString] forKey:@"url"];
					
					[itemsController reorderByMovingObjects:[NSArray arrayWithObject:object] toArrangedObjectIndex:row];
//					[object setValue:[NSNumber numberWithInt:row] forKey:@"order"];
					[itemsController rearrangeObjects];
					[itemsController setSelectionIndex:row];
//				[bookmark release];
					return YES;
				}
			}
		}
	}
	return NO;
}

@end
